<?php
require_once '../config/config.php';

// Set headers to prevent caching
header('Cache-Control: no-cache, must-revalidate');
header('Content-Type: application/json');

// Get recent payments
$query = "
    SELECT 
        p.*,
        s.student_number,
        s.first_name,
        s.last_name,
        ft.name as fee_type,
        ft.amount as total_fee_amount,
        sf.id as student_fee_id,
        ay.year_name,
        (
            SELECT SUM(amount) 
            FROM payments 
            WHERE student_fee_id = sf.id 
            AND status = 'confirmed'
        ) as total_paid_amount
    FROM payments p
    JOIN student_fees sf ON p.student_fee_id = sf.id
    JOIN students s ON sf.student_id = s.id
    JOIN fee_types ft ON sf.fee_type_id = ft.id
    JOIN academic_years ay ON sf.academic_year_id = ay.id
    ORDER BY p.created_at DESC
    LIMIT 10
";

$result = $conn->query($query);
$payments = [];

while ($row = $result->fetch_assoc()) {
    $progress = ($row['total_paid_amount'] / $row['total_fee_amount']) * 100;
    $progress = min(100, round($progress));
    
    $payments[] = [
        'id' => $row['id'],
        'student_name' => $row['first_name'] . ' ' . $row['last_name'],
        'student_number' => $row['student_number'],
        'amount' => $row['amount'],
        'status' => $row['status'],
        'fee_type' => $row['fee_type'],
        'academic_year' => $row['year_name'],
        'reference' => $row['reference_number'],
        'created_at' => $row['created_at'],
        'progress' => $progress,
        'total_paid' => $row['total_paid_amount'],
        'total_amount' => $row['total_fee_amount']
    ];
}

// Get payment statistics
$stats_query = "
    SELECT 
        COUNT(*) as total_payments,
        SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_count,
        SUM(CASE WHEN status = 'confirmed' THEN 1 ELSE 0 END) as confirmed_count,
        SUM(CASE WHEN status = 'confirmed' THEN amount ELSE 0 END) as confirmed_amount,
        SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as pending_amount
    FROM payments
";

$stats_result = $conn->query($stats_query);
$stats = $stats_result->fetch_assoc();

echo json_encode([
    'payments' => $payments,
    'stats' => $stats
]);
?>