<?php
require_once '../config/config.php';
require_once '../controllers/AuthController.php';
require_once '../includes/functions.php';

session_start();

// Admin access check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['student_id']) && isset($_POST['user_id'])) {
    try {
        $student_id = intval($_POST['student_id']);
        $user_id = intval($_POST['user_id']);
        
        // Start transaction
        $conn->begin_transaction();
        
        // Delete from students table
        $sql = "DELETE FROM students WHERE id = ?";
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("i", $student_id);
        if (!$stmt->execute()) {
            throw new Exception("Failed to delete from students table: " . $stmt->error);
        }
        
        // Delete from users table
        $sql = "DELETE FROM users WHERE id = ?";
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("i", $user_id);
        if (!$stmt->execute()) {
            throw new Exception("Failed to delete from users table: " . $stmt->error);
        }
        
        $conn->commit();
        $_SESSION['message'] = '<div class="alert alert-success alert-dismissible fade show" role="alert">
            Student deleted successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>';
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['message'] = '<div class="alert alert-danger alert-dismissible fade show" role="alert">
            Error deleting student: ' . htmlspecialchars($e->getMessage()) . '
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>';
    }
}

header('Location: dashboard.php');
exit();