﻿<?php
header('Content-Type: text/html; charset=utf-8');

// Initialize required files
require_once "../config/config.php";
require_once "../controllers/AuthController.php";
require_once "../includes/functions.php";
require_once "../includes/Database.php";

session_start();

// Basic access control
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != "admin") {
    header("Location: ../login.php");
    exit();
}

$db = Database::getInstance();
$conn = $db->getConnection();

// Initialize messages
$success_message = isset($_SESSION["success_message"]) ? $_SESSION["success_message"] : "";
$error_message = isset($_SESSION["error_message"]) ? $_SESSION["error_message"] : "";
unset($_SESSION["success_message"], $_SESSION["error_message"]);

$page_title = "Manage Students";
require_once "../includes/header.php";

// Get all students
$query = "SELECT s.*, p.program_code, u.email, u.status 
          FROM students s 
          JOIN programs p ON s.program_id = p.id 
          JOIN users u ON s.user_id = u.id 
          ORDER BY s.last_name, s.first_name";
$result = $conn->query($query);

// Get programs for filter
$programs = $conn->query("SELECT * FROM programs ORDER BY program_code");
?>

<div class="container-fluid py-4">
    <div class="card">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Manage Students</h5>
            <a href="register_student.php" class="btn btn-light"><i class="fas fa-plus"></i> Add New Student</a>
        </div>
        
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Student Number</th>
                            <th>Name</th>
                            <th>Program</th>
                            <th>Level</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row["student_number"]); ?></td>
                                <td><?php echo htmlspecialchars($row["last_name"] . ", " . $row["first_name"]); ?></td>
                                <td>
                                    <span class="badge bg-info">
                                        <?php echo htmlspecialchars($row["program_code"]); ?>
                                    </span>
                                </td>
                                <td>Level <?php echo $row["year_level"]; ?></td>
                                <td><?php echo htmlspecialchars($row["email"]); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $row["status"] === "active" ? "success" : "danger"; ?>">
                                        <?php echo ucfirst($row["status"]); ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="edit_student.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once "../includes/footer.php"; ?>
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
