﻿<?php
require_once '../config/config.php';
require_once '../controllers/AuthController.php';
require_once '../includes/Database.php';

session_start();

// Only admin can access this page
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}

$db = Database::getInstance();
$conn = $db->getConnection();

$success_message = '';
$error_message = '';

// Get list of programs
$programs_query = "SELECT * FROM programs ORDER BY program_code";
$programs_result = $conn->query($programs_query);
$programs = [];
while ($row = $programs_result->fetch_assoc()) {
    $programs[$row['id']] = $row['program_code'] . ' - ' . $row['program_name'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate input
    $required_fields = ['student_number', 'first_name', 'last_name', 'program_id', 'year_level', 
                       'email', 'password'];
    
    $missing_fields = [];
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            $missing_fields[] = $field;
        }
    }

    if (!empty($missing_fields)) {
        $error_message = "Please fill in all required fields: " . implode(", ", $missing_fields);
    } else {
        // Start transaction
        $conn->begin_transaction();

        try {
            // First create user account
            $email = $_POST['email'];
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $username = $_POST['student_number']; // Using student number as username
            
            $stmt = $conn->prepare("INSERT INTO users (username, password, email, role, status) VALUES (?, ?, ?, 'student', 'active')");
            $stmt->bind_param("sss", $username, $password, $email);
            
            if ($stmt->execute()) {
                $user_id = $conn->insert_id;
                
                // Then create student record
                $stmt = $conn->prepare("INSERT INTO students (user_id, student_number, first_name, last_name, 
                    program_id, year_level, contact_number, address) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                
                $stmt->bind_param("isssisss", 
                    $user_id,
                    $_POST['student_number'],
                    $_POST['first_name'],
                    $_POST['last_name'],
                    $_POST['program_id'],
                    $_POST['year_level'],
                    $_POST['contact_number'],
                    $_POST['address']
                );
                
                if ($stmt->execute()) {
                    $conn->commit();
                    $success_message = "Student registered successfully!";
                    
                    // Send welcome email
                    $to = $email;
                    $subject = "Welcome to KCOE Fee Payment System";
                    $message = "Dear " . $_POST['first_name'] . ",\n\n"
                            . "Welcome to KCOE Fee Payment System. Your account has been created successfully.\n"
                            . "You can now log in with your credentials:\n\n"
                            . "Username: " . $username . "\n"
                            . "Password: " . $_POST['password'] . "\n\n"
                            . "Please change your password after your first login.\n\n"
                            . "Best regards,\nKCOE Admin";
                    
                    $headers = "From: " . SMTP_USER;
                    
                    mail($to, $subject, $message, $headers);
                }
            }
        } catch (Exception $e) {
            $conn->rollback();
            $error_message = "Error: " . $e->getMessage();
        }
    }
}

$page_title = "Register New Student";
require_once "../includes/header.php";
?>

<div class="container-fluid py-4">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Register New Student</h5>
        </div>
        <div class="card-body">
            <?php if ($success_message): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($success_message); ?></div>
            <?php endif; ?>

            <?php if ($error_message): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error_message); ?></div>
            <?php endif; ?>

            <form method="POST" class="needs-validation" novalidate>
                <div class="row mb-4">
                    <div class="col-md-6">
                        <label for="student_number" class="form-label">Student Number *</label>
                        <input type="text" class="form-control" id="student_number" name="student_number" required>
                    </div>
                    <div class="col-md-6">
                        <label for="program_id" class="form-label">Program *</label>
                        <select class="form-select" id="program_id" name="program_id" required>
                            <option value="">Select Program</option>
                            <?php foreach ($programs as $id => $name): ?>
                                <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($name); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <label for="first_name" class="form-label">First Name *</label>
                        <input type="text" class="form-control" id="first_name" name="first_name" required>
                    </div>
                    <div class="col-md-6">
                        <label for="last_name" class="form-label">Last Name *</label>
                        <input type="text" class="form-control" id="last_name" name="last_name" required>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <label for="year_level" class="form-label">Year Level *</label>
                        <select class="form-select" id="year_level" name="year_level" required>
                            <option value="">Select Year Level</option>
                            <?php for($i = 1; $i <= 4; $i++): ?>
                                <option value="<?php echo $i; ?>">Level <?php echo $i; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label">Email *</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <label for="contact_number" class="form-label">Contact Number</label>
                        <input type="text" class="form-control" id="contact_number" name="contact_number">
                    </div>
                    <div class="col-md-6">
                        <label for="password" class="form-label">Initial Password *</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                    </div>
                </div>

                <div class="mb-4">
                    <label for="address" class="form-label">Address</label>
                    <textarea class="form-control" id="address" name="address" rows="3"></textarea>
                </div>

                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <a href="manage_students.php" class="btn btn-secondary me-md-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">Register Student</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Form validation
(function() {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<?php require_once "../includes/footer.php"; ?>