<?php
require_once '../config/config.php';
require_once '../controllers/AuthController.php';
require_once '../includes/functions.php';

session_start();

// Admin access check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_id']) && isset($_POST['student_number'])) {
    try {
        $user_id = intval($_POST['user_id']);
        $student_number = $conn->real_escape_string($_POST['student_number']);
        
        // Reset password to student number
        $password_hash = password_hash($student_number, PASSWORD_DEFAULT);
        
        $sql = "UPDATE users SET password = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("si", $password_hash, $user_id);
        if ($stmt->execute()) {
            $_SESSION['message'] = '<div class="alert alert-success alert-dismissible fade show" role="alert">
                Password reset successfully! New password is the student number.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>';
        } else {
            throw new Exception("Execute failed: " . $stmt->error);
        }
    } catch (Exception $e) {
        $_SESSION['message'] = '<div class="alert alert-danger alert-dismissible fade show" role="alert">
            Error resetting password: ' . htmlspecialchars($e->getMessage()) . '
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>';
    }
}

header('Location: dashboard.php');
exit();