<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/fee_sync.php';

try {
    // Get all students
    $stmt = $conn->prepare("
        SELECT s.id, s.student_number, s.first_name, s.last_name, p.program_name
        FROM students s
        JOIN programs p ON s.program_id = p.id
        ORDER BY p.program_name, s.student_number
    ");
    $stmt->execute();
    $students = $stmt->get_result();

    echo "<html><head><title>Fee Sync Results</title>";
    echo "<style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f4f4f4; }
        .success { color: green; }
        .error { color: red; }
        </style></head><body>";
    echo "<h2>Student Fee Synchronization Results</h2>";
    echo "<table>";
    echo "<tr><th>Student Number</th><th>Name</th><th>Program</th><th>Status</th></tr>";

    $updated = 0;
    $errors = 0;

    while ($student = $students->fetch_assoc()) {
        echo "<tr>";
        echo "<td>{$student['student_number']}</td>";
        echo "<td>{$student['first_name']} {$student['last_name']}</td>";
        echo "<td>{$student['program_name']}</td>";
        
        try {
            syncStudentFees($conn, $student['id']);
            echo "<td class='success'>Fees synchronized successfully</td>";
            $updated++;
        } catch (Exception $e) {
            echo "<td class='error'>Error: " . htmlspecialchars($e->getMessage()) . "</td>";
            $errors++;
        }
        
        echo "</tr>";
        
        // Flush output after each student
        ob_flush();
        flush();
    }

    echo "</table>";
    echo "<h3>Summary:</h3>";
    echo "<p>Total students processed: " . ($updated + $errors) . "<br>";
    echo "Successfully updated: {$updated}<br>";
    echo "Errors encountered: {$errors}</p>";
    echo "<p><a href='../admin/'>Return to Admin Dashboard</a></p>";
    echo "</body></html>";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}