<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/fee_sync.php';

try {
    // Get all Mathematics Science students
    $stmt = $conn->prepare("
        SELECT s.id 
        FROM students s
        JOIN programs p ON s.program_id = p.id
        WHERE p.program_name = 'Mathematics Science'
    ");
    $stmt->execute();
    $students = $stmt->get_result();

    $updated = 0;
    while ($student = $students->fetch_assoc()) {
        syncStudentFees($conn, $student['id']);
        $updated++;
    }

    echo "Successfully updated fees for {$updated} students.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}