<?php
require_once '../config/config.php';
require_once '../controllers/AuthController.php';
require_once '../includes/functions.php';

session_start();

// Admin access check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['student_id']) && isset($_POST['course']) && isset($_POST['year_level'])) {
    try {
        $student_id = intval($_POST['student_id']);
        $course = $conn->real_escape_string($_POST['course']);
        $year_level = intval($_POST['year_level']);
        
        $sql = "UPDATE students SET course = ?, year_level = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("sii", $course, $year_level, $student_id);
        if ($stmt->execute()) {
            $_SESSION['message'] = '<div class="alert alert-success alert-dismissible fade show" role="alert">
                Student program updated successfully!
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>';
        } else {
            throw new Exception("Execute failed: " . $stmt->error);
        }
    } catch (Exception $e) {
        $_SESSION['message'] = '<div class="alert alert-danger alert-dismissible fade show" role="alert">
            Error updating student program: ' . htmlspecialchars($e->getMessage()) . '
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>';
    }
}

header('Location: dashboard.php');
exit();