<?php
require_once 'config/config.php';
require_once 'includes/functions.php';

session_start();

// Get student ID from session
$user_id = $_SESSION['user_id'];

// Get student and program details
$stmt = $conn->prepare("
    SELECT s.id as student_id, s.program_id, s.first_name, s.last_name, 
           p.program_name, p.program_code
    FROM students s 
    LEFT JOIN programs p ON s.program_id = p.id 
    WHERE s.user_id = ?
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$student = $stmt->get_result()->fetch_assoc();

echo "<h2>Diagnostic Information</h2>";
echo "<h3>1. Student Information:</h3>";
echo "Student ID: " . $student['student_id'] . "<br>";
echo "Name: " . $student['first_name'] . " " . $student['last_name'] . "<br>";
echo "Program ID: " . $student['program_id'] . "<br>";
echo "Program Name: " . $student['program_name'] . "<br><br>";

// Check program fees assignments
echo "<h3>2. Program Fee Assignments:</h3>";
$stmt = $conn->prepare("
    SELECT pf.*, ft.name as fee_name, ft.amount, ay.year_name
    FROM program_fees pf
    JOIN fee_types ft ON pf.fee_type_id = ft.id
    JOIN academic_years ay ON pf.academic_year_id = ay.id
    WHERE pf.program_id = ?
");
$stmt->bind_param("i", $student['program_id']);
$stmt->execute();
$program_fees = $stmt->get_result();

if ($program_fees->num_rows > 0) {
    echo "Fees assigned to your program:<br>";
    while ($fee = $program_fees->fetch_assoc()) {
        echo "- {$fee['fee_name']} ({$fee['amount']}) for {$fee['year_name']}<br>";
    }
} else {
    echo "No fees have been assigned to your program.<br>";
}

// Check student fees
echo "<h3>3. Student Fee Assignments:</h3>";
$stmt = $conn->prepare("
    SELECT sf.*, ft.name as fee_name, ft.amount as original_amount,
           ay.year_name,
           COALESCE((SELECT SUM(amount) FROM payments WHERE student_fee_id = sf.id AND status = 'confirmed'), 0) as paid_amount
    FROM student_fees sf
    JOIN fee_types ft ON sf.fee_type_id = ft.id
    JOIN academic_years ay ON sf.academic_year_id = ay.id
    WHERE sf.student_id = ?
");
$stmt->bind_param("i", $student['student_id']);
$stmt->execute();
$student_fees = $stmt->get_result();

if ($student_fees->num_rows > 0) {
    echo "Your assigned fees:<br>";
    while ($fee = $student_fees->fetch_assoc()) {
        $remaining = $fee['original_amount'] - $fee['paid_amount'];
        echo "- {$fee['fee_name']} ({$fee['original_amount']}) for {$fee['year_name']}<br>";
        echo "  Status: {$fee['status']}, Paid: {$fee['paid_amount']}, Remaining: {$remaining}<br>";
    }
} else {
    echo "No fees have been directly assigned to you.<br>";
}

// Check active academic years
echo "<h3>4. Active Academic Years:</h3>";
$result = $conn->query("SELECT * FROM academic_years WHERE status = 'active'");
if ($result->num_rows > 0) {
    while ($year = $result->fetch_assoc()) {
        echo "- {$year['year_name']} (ID: {$year['id']})<br>";
    }
} else {
    echo "No active academic years found.<br>";
}

// Check available fee types
echo "<h3>5. Available Fee Types:</h3>";
$result = $conn->query("SELECT * FROM fee_types WHERE status = 'active'");
if ($result->num_rows > 0) {
    while ($fee = $result->fetch_assoc()) {
        echo "- {$fee['name']} (Amount: {$fee['amount']})<br>";
    }
} else {
    echo "No active fee types found.<br>";
}
?>