<?php
// Production configuration file - Last updated: October 7, 2025

// Security headers
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('X-Content-Type-Options: nosniff');
header('Strict-Transport-Security: max-age=31536000; includeSubDomains');
header('Referrer-Policy: strict-origin-when-cross-origin');

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'kmceonli_itsupport');
define('DB_PASS', 'A!!!!!26boaha');
define('DB_NAME', 'kmceonli_kcoefeepayment');

// Application configuration
define('BASE_URL', 'https://kcoefeepayment.kmceonlineportal.com');
define('APP_NAME', 'KCOE Fee Payment System');
define('CURRENCY', 'GH₵'); // Ghana Cedis

// Email configuration - Update with your actual email settings
define('SMTP_HOST', 'mail.kmceonlineportal.com'); // Update with your hosting's SMTP server
define('SMTP_PORT', 587);
define('SMTP_USER', 'noreply@kmceonlineportal.com'); // Update with your email
define('SMTP_PASS', ''); // Set your actual email password

// Session security configuration
define('SESSION_TIMEOUT', 1800); // 30 minutes
ini_set('session.cookie_secure', 1);
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_samesite', 'Strict');

// Date configuration
define('DEFAULT_DATE_FORMAT', 'M d, Y');
define('DEFAULT_TIME_FORMAT', 'g:i A');
define('DEFAULT_DATETIME_FORMAT', 'M d, Y g:i A');
define('DATABASE_DATE_FORMAT', 'Y-m-d');
define('DATABASE_DATETIME_FORMAT', 'Y-m-d H:i:s');
define('DEFAULT_TIMEZONE', 'Africa/Accra'); // Ghana timezone

// Set default timezone
date_default_timezone_set(DEFAULT_TIMEZONE);

// Production error handling - Log errors but don't display them
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// Initialize database connection
try {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        error_log("Database connection failed: " . $conn->connect_error);
        throw new Exception("Database connection failed. Please try again later.");
    }
    
    // Set charset to ensure proper string handling
    $conn->set_charset("utf8mb4");
    
    // Disable error reporting for mysqli in production
    mysqli_report(MYSQLI_REPORT_OFF);
    
} catch (Exception $e) {
    error_log($e->getMessage());
    die("A database error occurred. Please try again later.");
}