<?php
class AuthController {
    private $conn;
    
    public function __construct($db) {
        $this->conn = $db;
    }
    
    public function login($username, $password) {
        error_log("============= LOGIN ATTEMPT START =============");
        error_log("Username: " . $username);
        error_log("Password length: " . strlen($password));
        
        if (!$this->conn) {
            error_log("Database connection error");
            return ['success' => false, 'message' => 'Database error'];
        }
        
        try {
            // Check if we can query the database
            $test_query = $this->conn->query("SELECT 1");
            if (!$test_query) {
                error_log("Database connection test failed: " . $this->conn->error);
                return ['success' => false, 'message' => 'Database error'];
            }
            error_log("Database connection test successful");
            
            // First, let's see what users exist
            $all_users = $this->conn->query("SELECT username, role FROM users");
            error_log("Existing users in database:");
            while ($u = $all_users->fetch_assoc()) {
                error_log("- {$u['username']} ({$u['role']})");
            }
            
            $stmt = $this->conn->prepare("SELECT * FROM users WHERE username = ?");
            if (!$stmt) {
                error_log("Prepare statement failed: " . $this->conn->error);
                return ['success' => false, 'message' => 'Database error'];
            }
            
            $stmt->bind_param("s", $username);
            error_log("Searching for user: " . $username);
            
            if (!$stmt->execute()) {
                error_log("Execute failed: " . $stmt->error);
                return ['success' => false, 'message' => 'Database error'];
            }
            
            $result = $stmt->get_result();
            
            if ($result->num_rows === 0) {
                error_log("No user found with username: " . $username);
                return ['success' => false, 'message' => 'Invalid username or password'];
            }
            
            $user = $result->fetch_assoc();
            error_log("Found user: " . $username);
            error_log("User role: " . $user['role']);
            error_log("User status: " . $user['status']);
            error_log("Input password length: " . strlen($password));
            error_log("Stored hash: " . $user['password']);
            
            if ($user['status'] !== 'active') {
                error_log("User account is not active");
                return ['success' => false, 'message' => 'Account is not active'];
            }
            
            error_log("Verifying password...");
            $password_match = password_verify($password, $user['password']);
            error_log("Password verification result: " . ($password_match ? "TRUE" : "FALSE"));
            
            if ($password_match) {
                error_log("Login successful for user: " . $username . " with role: " . $user['role']);
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['role'] = $user['role'];
                $_SESSION['last_activity'] = time();
                return ['success' => true, 'user' => $user];
            }
            
            error_log("Password verification failed");
            return ['success' => false, 'message' => 'Invalid username or password'];
        } catch (Exception $e) {
            error_log("Login error: " . $e->getMessage());
            return ['success' => false, 'message' => 'System error, please try again'];
        } finally {
            error_log("============= LOGIN ATTEMPT END =============");
        }
    }
    
    public function logout() {
        session_destroy();
        return ['success' => true];
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }
}