<?php
class EmailNotification {
    private $from_email;
    private $from_name;
    private $smtp_config;
    
    public function __construct() {
        $this->from_email = 'noreply@kcoe.edu';
        $this->from_name = 'KCOE Fee Payment System';
        
        // SMTP configuration (update with your SMTP settings)
        $this->smtp_config = [
            'host' => 'smtp.gmail.com',
            'port' => 587,
            'username' => 'your-email@gmail.com',
            'password' => 'your-app-password',
            'encryption' => 'tls'
        ];
    }
    
    public function sendPaymentSubmissionNotification($student, $payment) {
        $subject = "Payment Submission Confirmation";
        $message = "
            <h2>Payment Submission Confirmation</h2>
            <p>Dear " . htmlspecialchars($student['first_name']) . ",</p>
            <p>Your payment has been submitted successfully and is pending confirmation:</p>
            <ul>
                <li>Amount: GHs " . number_format($payment['amount'], 2) . "</li>
                <li>Reference Number: " . htmlspecialchars($payment['reference_number']) . "</li>
                <li>Payment Method: " . ucfirst($payment['payment_method']) . "</li>
                <li>Date: " . date('F d, Y H:i:s') . "</li>
            </ul>
            <p>You will receive another email once your payment is confirmed by the accountant.</p>
        ";
        
        return $this->sendEmail($student['email'], $subject, $message);
    }
    
    public function sendPaymentConfirmationNotification($student, $payment) {
        $subject = "Payment Confirmed";
        $message = "
            <h2>Payment Confirmation</h2>
            <p>Dear " . htmlspecialchars($student['first_name']) . ",</p>
            <p>Your payment has been confirmed successfully:</p>
            <ul>
                <li>Amount: GHs " . number_format($payment['amount'], 2) . "</li>
                <li>Reference Number: " . htmlspecialchars($payment['reference_number']) . "</li>
                <li>Payment Method: " . ucfirst($payment['payment_method']) . "</li>
                <li>Confirmation Date: " . date('F d, Y H:i:s') . "</li>
            </ul>
            <p>You can view your updated fee statement by logging into your student portal.</p>
        ";
        
        return $this->sendEmail($student['email'], $subject, $message);
    }
    
    public function sendPaymentRejectionNotification($student, $payment, $reason) {
        $subject = "Payment Rejected";
        $message = "
            <h2>Payment Rejection Notice</h2>
            <p>Dear " . htmlspecialchars($student['first_name']) . ",</p>
            <p>Unfortunately, your payment has been rejected:</p>
            <ul>
                <li>Amount: GHs " . number_format($payment['amount'], 2) . "</li>
                <li>Reference Number: " . htmlspecialchars($payment['reference_number']) . "</li>
                <li>Payment Method: " . ucfirst($payment['payment_method']) . "</li>
                <li>Rejection Date: " . date('F d, Y H:i:s') . "</li>
            </ul>
            <p><strong>Reason for rejection:</strong> " . htmlspecialchars($reason) . "</p>
            <p>Please contact the accounts office if you need any clarification.</p>
        ";
        
        return $this->sendEmail($student['email'], $subject, $message);
    }
    
    public function sendFeeReminderNotification($student, $fee) {
        $subject = "Fee Payment Reminder";
        $message = "
            <h2>Fee Payment Reminder</h2>
            <p>Dear " . htmlspecialchars($student['first_name']) . ",</p>
            <p>This is a reminder that you have an upcoming fee payment due:</p>
            <ul>
                <li>Fee Type: " . htmlspecialchars($fee['fee_type']) . "</li>
                <li>Amount Due: GHs " . number_format($fee['amount'], 2) . "</li>
                <li>Due Date: " . date('F d, Y', strtotime($fee['due_date'])) . "</li>
            </ul>
            <p>Please ensure to make the payment before the due date to avoid any late payment penalties.</p>
            <p>You can make your payment through the student portal.</p>
        ";
        
        return $this->sendEmail($student['email'], $subject, $message);
    }
    
    public function sendLowBalanceNotification($student, $balance) {
        $subject = "Low Balance Alert";
        $message = "
            <h2>Low Balance Alert</h2>
            <p>Dear " . htmlspecialchars($student['first_name']) . ",</p>
            <p>Your current balance is below the minimum required amount:</p>
            <ul>
                <li>Current Balance: GHs " . number_format($balance, 2) . "</li>
            </ul>
            <p>Please top up your account to avoid any service interruptions.</p>
        ";
        
        return $this->sendEmail($student['email'], $subject, $message);
    }
    
    private function sendEmail($to, $subject, $message) {
        // Add email template wrapper
        $full_message = $this->getEmailTemplate($message);
        
        // Email headers
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= 'From: ' . $this->from_name . ' <' . $this->from_email . '>' . "\r\n";
        
        // Send email
        return mail($to, $subject, $full_message, $headers);
    }
    
    private function getEmailTemplate($content) {
        return '
            <!DOCTYPE html>
            <html>
            <head>
                <style>
                    body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                    .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                    .header { background: #007bff; color: white; padding: 20px; text-align: center; }
                    .content { background: #fff; padding: 20px; }
                    .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
                </style>
            </head>
            <body>
                <div class="container">
                    <div class="header">
                        <h1>KCOE Fee Payment System</h1>
                    </div>
                    <div class="content">
                        ' . $content . '
                    </div>
                    <div class="footer">
                        <p>This is an automated message, please do not reply to this email.</p>
                        <p>&copy; ' . date('Y') . ' KCOE Fee Payment System. All rights reserved.</p>
                    </div>
                </div>
            </body>
            </html>
        ';
    }
}