<?php
// Add these functions to the existing functions.php file

// Format date in the standard application format
function formatDate($date, $format = 'M d, Y') {
    if (!$date) return '';
    return date($format, strtotime($date));
}

// Format datetime in the standard application format
function formatDateTime($datetime, $format = 'M d, Y g:i A') {
    if (!$datetime) return '';
    return date($format, strtotime($datetime));
}

// Validate if a date is in the future
function isFutureDate($date) {
    return strtotime($date) > time();
}

// Get academic year date range
function getAcademicYearDates($conn) {
    $stmt = $conn->prepare("
        SELECT start_date, end_date 
        FROM academic_years 
        WHERE is_current = 1 
        LIMIT 1
    ");
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

// Calculate the default due date for new fees
function calculateDefaultDueDate($conn) {
    $academic_year = getAcademicYearDates($conn);
    return $academic_year['end_date'] ?? date('Y-m-d', strtotime('+6 months'));
}

// Check if a date falls within the current academic year
function isWithinAcademicYear($date, $conn) {
    $academic_year = getAcademicYearDates($conn);
    $date_ts = strtotime($date);
    return $date_ts >= strtotime($academic_year['start_date']) && 
           $date_ts <= strtotime($academic_year['end_date']);
}