<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

function debugLog($message, $data = null) {
    $logFile = __DIR__ . '/webhook_debug.log';
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[{$timestamp}] {$message}\n";
    
    if ($data !== null) {
        $logEntry .= json_encode($data, JSON_PRETTY_PRINT) . "\n";
    }
    
    $logEntry .= "----------------------------------------\n";
    file_put_contents($logFile, $logEntry, FILE_APPEND);
}