<?php
// Function to sync program fees to student fees
function syncStudentFees($conn, $student_id) {
    try {
        $conn->begin_transaction();

        // Get student's program ID
        $stmt = $conn->prepare("SELECT program_id FROM students WHERE id = ?");
        $stmt->bind_param("i", $student_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $student = $result->fetch_assoc();

        if (!$student) {
            throw new Exception("Student not found");
        }

        // Get all program fees for the student's program
        $stmt = $conn->prepare("
            SELECT 
                pf.*,
                ft.amount as fee_amount
            FROM program_fees pf
            JOIN fee_types ft ON pf.fee_type_id = ft.id
            WHERE pf.program_id = ?
        ");
        $stmt->bind_param("i", $student['program_id']);
        $stmt->execute();
        $program_fees = $stmt->get_result();

        // Insert or update student fees
        while ($fee = $program_fees->fetch_assoc()) {
            // Check if fee already exists
            $stmt = $conn->prepare("
                SELECT id 
                FROM student_fees 
                WHERE student_id = ? 
                AND fee_type_id = ? 
                AND academic_year_id = ?
            ");
            $stmt->bind_param("iii", $student_id, $fee['fee_type_id'], $fee['academic_year_id']);
            $stmt->execute();
            $exists = $stmt->get_result()->fetch_assoc();

            if (!$exists) {
                // Insert new fee
                $stmt = $conn->prepare("
                    INSERT INTO student_fees (
                        student_id, 
                        fee_type_id, 
                        academic_year_id, 
                        amount, 
                        due_date, 
                        status
                    ) VALUES (?, ?, ?, ?, DATE_ADD(CURRENT_DATE, INTERVAL 30 DAY), 'pending')
                ");
                $stmt->bind_param("iiid", 
                    $student_id, 
                    $fee['fee_type_id'], 
                    $fee['academic_year_id'], 
                    $fee['fee_amount']
                );
                $stmt->execute();
            }
        }

        $conn->commit();
        return true;
    } catch (Exception $e) {
        $conn->rollback();
        throw $e;
    }
}