<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session
session_start();

// Include required files
require_once 'config/config.php';
require_once 'controllers/AuthController.php';

// Debug log
error_log("Login page accessed");

// If user is already logged in, redirect to appropriate dashboard
if (isset($_SESSION['user_id'])) {
    error_log("User already logged in: " . print_r($_SESSION, true));
    switch ($_SESSION['role']) {
        case 'admin':
            header('Location: admin/dashboard.php');
            break;
        case 'accountant':
            header('Location: accountant/dashboard.php');
            break;
        case 'student':
            header('Location: student/dashboard.php');
            break;
        default:
            // Invalid role, destroy session and show error
            session_destroy();
            $error = 'Invalid user role. Please log in again.';
    }
    exit();
}

$error = '';
$success = '';

// Process login form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    error_log("Login attempt received");
    
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = 'Please enter both username and password.';
        error_log("Empty username or password");
    } else {
        try {
            $auth = new AuthController($conn);
            $login_result = $auth->login($username, $password);
            error_log("Login attempt result: " . print_r($login_result, true));

            if ($login_result['success']) {
                error_log("Login successful for user: " . $username);
                switch ($_SESSION['role']) {
                    case 'admin':
                        header('Location: admin/dashboard.php');
                        break;
                    case 'accountant':
                        header('Location: accountant/dashboard.php');
                        break;
                    case 'student':
                        header('Location: student/dashboard.php');
                        break;
                    default:
                        throw new Exception('Invalid user role');
                }
                exit();
            } else {
                $error = $login_result['message'];
                error_log("Login failed: " . $error);
            }
        } catch (Exception $e) {
            error_log("Login exception: " . $e->getMessage());
            $error = 'An error occurred. Please try again later.';
        }
    }
    
    // Debug login result
    error_log("Login attempt result: " . print_r($login_result, true));
    
    if ($login_result['success']) {
        // Redirect based on role
        switch ($_SESSION['role']) {
            case 'admin':
                header('Location: admin/dashboard.php');
                break;
            case 'accountant':
                header('Location: accountant/dashboard.php');
                break;
            case 'student':
                header('Location: student/dashboard.php');
                break;
        }
        exit();
    } else {
        $error = isset($login_result['message']) ? $login_result['message'] : 'Invalid username or password';
        error_log("Login failed: " . $error);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - KCOE Fee Payment System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .login-container {
            max-width: 400px;
            margin: 100px auto;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .card-header {
            background-color: #3d0217;
            color: white;
            text-align: center;
            padding: 20px;
            border-radius: 10px 10px 0 0;
        }
        .card-body {
            padding: 30px;
        }
        .btn-primary {
            background-color: #3d0217;
            border-color: #3d0217;
        }
        .btn-primary:hover {
            background-color: #2d0111;
            border-color: #2d0111;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-container">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">KCOE Fee Payment System</h4>
                </div>
                <div class="card-body">
                    <?php if ($error): ?>
                        <div class="alert alert-danger" role="alert">
                            <?php echo htmlspecialchars($error); ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="username" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Login</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>