<?php
require_once '../config/config.php';
require_once '../config/payment_config.php';
require_once '../includes/functions.php';

// Function to verify payment with Paystack
function verifyPaystackPayment($reference) {
    $url = "https://api.paystack.co/transaction/verify/" . urlencode($reference);
    $headers = [
        'Authorization: Bearer ' . PAYSTACK_SECRET_KEY
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    
    if ($err) {
        echo "Error: " . $err;
        return false;
    }
    
    return json_decode($response, true);
}

// Function to update payment status
function updatePaymentStatus($reference, $paystack_data) {
    global $conn;
    
    // Update payment status
    $stmt = $conn->prepare("UPDATE payments SET status = 'confirmed', payment_data = ? WHERE reference_number = ? AND status = 'pending'");
    $stmt->bind_param("ss", json_encode($paystack_data), $reference);
    
    if (!$stmt->execute()) {
        echo "Error updating payment: " . $stmt->error;
        return false;
    }
    
    if ($stmt->affected_rows > 0) {
        // Update student fee status
        $stmt = $conn->prepare("
            UPDATE student_fees sf
            SET status = 
                CASE 
                    WHEN (SELECT SUM(amount) FROM payments WHERE student_fee_id = sf.id AND status = 'confirmed') >= sf.amount 
                    THEN 'paid'
                    ELSE 'partial'
                END
            WHERE id = (SELECT student_fee_id FROM payments WHERE reference_number = ?)
        ");
        $stmt->bind_param("s", $reference);
        $stmt->execute();
        return true;
    }
    return false;
}

// Get the reference from the latest pending payment
$reference = 'KCOE_1759588272_71_30'; // Latest payment reference

// Verify the payment
$verification = verifyPaystackPayment($reference);

echo "<pre>";
if ($verification && $verification['status']) {
    echo "Payment Status from Paystack: " . $verification['data']['status'] . "\n";
    if ($verification['data']['status'] === 'success') {
        if (updatePaymentStatus($reference, $verification['data'])) {
            echo "Payment status updated successfully!\n";
        } else {
            echo "Failed to update payment status.\n";
        }
    } else {
        echo "Payment not successful according to Paystack.\n";
    }
} else {
    echo "Failed to verify payment with Paystack.\n";
}
echo "</pre>";
?>