<?php
require_once '../config/config.php';
require_once '../config/payment_config.php';
require_once '../includes/functions.php';

$reference = $_GET['reference'] ?? '';

if (empty($reference)) {
    die('No reference provided');
}

// Verify the transaction status with Paystack
$url = "https://api.paystack.co/transaction/verify/" . urlencode($reference);
$headers = [
    'Authorization: Bearer ' . PAYSTACK_SECRET_KEY
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    die('Error: ' . $err);
}

$result = json_decode($response, true);
echo '<pre>';
print_r($result);
echo '</pre>';

// If payment is successful, update the status
if ($result['status'] && $result['data']['status'] === 'success') {
    $stmt = $conn->prepare("UPDATE payments SET status = 'confirmed' WHERE reference_number = ?");
    $stmt->bind_param("s", $reference);
    if ($stmt->execute()) {
        echo "Payment status updated successfully!";
    } else {
        echo "Error updating payment status: " . $stmt->error;
    }
}
?>