<?php
require_once '../config/config.php';
require_once '../config/payment_config.php';
require_once '../includes/functions.php';

// Get the latest pending payment
$query = "SELECT p.*, sf.student_id, s.first_name, s.last_name 
          FROM payments p
          JOIN student_fees sf ON p.student_fee_id = sf.id
          JOIN students s ON sf.student_id = s.id
          WHERE p.status = 'pending' 
          ORDER BY p.created_at DESC LIMIT 1";
$result = $conn->query($query);
$payment = $result->fetch_assoc();

if (!$payment) {
    die("No pending payments found");
}

// Function to verify with Paystack
function verifyWithPaystack($reference) {
    $url = "https://api.paystack.co/transaction/verify/" . urlencode($reference);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer " . PAYSTACK_SECRET_KEY
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// Verify with Paystack
$verification = verifyWithPaystack($payment['reference_number']);

if ($verification && $verification['status']) {
    // Create webhook payload
    $payload = [
        'event' => 'charge.success',
        'data' => $verification['data']
    ];
    
    // Calculate signature
    $signature = hash_hmac('sha512', json_encode($payload), PAYSTACK_SECRET_KEY);
    
    // Send to webhook URL
    $ch = curl_init('http://localhost/KCOEFEEPAYMENT/payment/verify_paystack.php');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Paystack-Signature: ' . $signature
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "<pre>";
    echo "Payment Reference: " . $payment['reference_number'] . "\n";
    echo "Webhook Response Code: " . $httpCode . "\n";
    echo "Webhook Response: " . $response . "\n";
    echo "</pre>";
} else {
    echo "Failed to verify payment with Paystack";
}
?>