<?php
require_once '../config/config.php';
require_once '../config/payment_config.php';
require_once '../includes/functions.php';

// Function to update payment status
function updatePaymentStatus($reference) {
    global $conn;
    
    // Update payment status
    $stmt = $conn->prepare("UPDATE payments SET status = 'confirmed' WHERE reference_number = ? AND status = 'pending'");
    $stmt->bind_param("s", $reference);
    $stmt->execute();
    
    if ($stmt->affected_rows > 0) {
        // Update student fee status
        $stmt = $conn->prepare("
            UPDATE student_fees sf
            SET status = 
                CASE 
                    WHEN (
                        SELECT SUM(amount) 
                        FROM payments 
                        WHERE student_fee_id = sf.id 
                        AND status = 'confirmed'
                    ) >= sf.amount 
                    THEN 'paid'
                    ELSE 'partial'
                END
            WHERE id = (
                SELECT student_fee_id 
                FROM payments 
                WHERE reference_number = ?
            )
        ");
        $stmt->bind_param("s", $reference);
        $stmt->execute();
        return true;
    }
    return false;
}

// Get all pending payments
$stmt = $conn->prepare("
    SELECT p.*, sf.student_id, s.first_name, s.last_name 
    FROM payments p
    JOIN student_fees sf ON p.student_fee_id = sf.id
    JOIN students s ON sf.student_id = s.id
    WHERE p.status = 'pending'
    ORDER BY p.created_at DESC
");
$stmt->execute();
$result = $stmt->get_result();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reference'])) {
    $reference = $_POST['reference'];
    if (updatePaymentStatus($reference)) {
        header("Location: verify_pending_payments.php?success=Payment updated successfully");
        exit();
    } else {
        header("Location: verify_pending_payments.php?error=Failed to update payment");
        exit();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Verify Pending Payments</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <div class="container">
        <h2>Pending Payments</h2>
        
        <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div>
        <?php endif; ?>
        
        <?php if (isset($_GET['error'])): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div>
        <?php endif; ?>
        
        <table class="table">
            <thead>
                <tr>
                    <th>Reference</th>
                    <th>Student</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($payment = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($payment['reference_number']); ?></td>
                        <td><?php echo htmlspecialchars($payment['first_name'] . ' ' . $payment['last_name']); ?></td>
                        <td><?php echo htmlspecialchars(number_format($payment['amount'], 2)); ?></td>
                        <td><?php echo htmlspecialchars($payment['created_at']); ?></td>
                        <td>
                            <form method="post" style="display: inline;">
                                <input type="hidden" name="reference" value="<?php echo htmlspecialchars($payment['reference_number']); ?>">
                                <button type="submit" class="btn btn-primary btn-sm">Verify Payment</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>