<?php
require_once '../config/config.php';
require_once '../config/payment_config.php';
require_once '../includes/functions.php';
require_once '../includes/debug_logger.php';

header('Content-Type: application/json');

try {
    // Test webhook connectivity
    $test_payload = [
        'event' => 'test',
        'data' => [
            'message' => 'Testing webhook connectivity',
            'timestamp' => date('Y-m-d H:i:s')
        ]
    ];

    $json_payload = json_encode($test_payload);
    
    // Calculate signature using your secret key
    $signature = hash_hmac('sha512', $json_payload, PAYSTACK_SECRET_KEY);
    
    // Send test webhook
    $ch = curl_init(PAYSTACK_WEBHOOK_URL);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json_payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Paystack-Signature: ' . $signature
    ]);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        throw new Exception('Curl error: ' . curl_error($ch));
    }
    
    curl_close($ch);
    
    echo json_encode([
        'status' => 'success',
        'message' => 'Webhook test completed',
        'details' => [
            'http_code' => $http_code,
            'response' => json_decode($response, true),
            'webhook_url' => PAYSTACK_WEBHOOK_URL
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}