<?php
require_once '../config/config.php';
require_once '../controllers/AuthController.php';
require_once '../includes/functions.php';

session_start();

// Get student details from session
$user_id = $_SESSION['user_id'] ?? 0;

// Simple query to get unpaid fees
$query = "SELECT 
    sf.id,
    ft.name as fee_type,
    ft.amount as fee_amount,
    ay.year_name,
    sf.status,
    (SELECT COALESCE(SUM(amount), 0) 
     FROM payments 
     WHERE student_fee_id = sf.id 
     AND status = 'confirmed') as paid_amount
FROM students s
JOIN student_fees sf ON s.id = sf.student_id
JOIN fee_types ft ON sf.fee_type_id = ft.id
JOIN academic_years ay ON sf.academic_year_id = ay.id
JOIN users u ON s.user_id = u.id
WHERE u.id = ?
AND (sf.status != 'paid' OR sf.status IS NULL)";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

echo "<pre>";
echo "User ID: " . $user_id . "\n";
echo "Number of fees found: " . $result->num_rows . "\n\n";

while ($row = $result->fetch_assoc()) {
    print_r($row);
}
echo "</pre>";
?>