<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

session_start();

// Verify student access
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'student') {
    header('Location: ../login.php');
    exit();
}

$reference = $_GET['reference'] ?? '';
$error_message = $_GET['error'] ?? 'Your payment could not be processed at this time.';

$page_title = "Payment Failed";
require_once '../includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <div class="mb-4">
                        <i class="fas fa-times-circle text-danger" style="font-size: 64px;"></i>
                    </div>
                    <h2 class="mb-4">Payment Failed</h2>
                    <div class="alert alert-danger">
                        <p class="mb-0"><?php echo htmlspecialchars($error_message); ?></p>
                        <?php if ($reference): ?>
                            <p class="mt-2 mb-0">Reference: <?php echo htmlspecialchars($reference); ?></p>
                        <?php endif; ?>
                    </div>
                    <p class="text-muted">
                        If you believe this is an error, please contact the finance office with your reference number.
                    </p>
                    <div class="mt-4">
                        <a href="submit_payment.php" class="btn btn-primary">Try Again</a>
                        <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>