<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

session_start();

// Verify student access
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'student') {
    header('Location: ../login.php');
    exit();
}

$reference = $_GET['reference'] ?? '';

// Get payment details
$stmt = $conn->prepare("
    SELECT 
        p.*,
        ft.name as fee_type,
        s.first_name,
        s.last_name
    FROM payments p
    JOIN student_fees sf ON p.student_fee_id = sf.id
    JOIN fee_types ft ON sf.fee_type_id = ft.id
    JOIN students s ON sf.student_id = s.id
    WHERE p.reference_number = ? AND s.user_id = ?
");

$stmt->bind_param("si", $reference, $_SESSION['user_id']);
$stmt->execute();
$payment = $stmt->get_result()->fetch_assoc();

$page_title = "Payment Success";
require_once '../includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <div class="mb-4">
                        <i class="fas fa-check-circle text-success" style="font-size: 64px;"></i>
                    </div>
                    <h2 class="mb-4">Payment Successful!</h2>
                    <?php if ($payment): ?>
                        <div class="alert alert-success">
                            <h5>Payment Details:</h5>
                            <p class="mb-1">Amount: <?php echo formatMoney($payment['amount']); ?></p>
                            <p class="mb-1">Fee Type: <?php echo htmlspecialchars($payment['fee_type']); ?></p>
                            <p class="mb-1">Reference: <?php echo htmlspecialchars($payment['reference_number']); ?></p>
                            <p class="mb-0">Date: <?php echo date('Y-m-d H:i:s', strtotime($payment['payment_date'])); ?></p>
                        </div>
                        <p class="text-muted">
                            A confirmation email has been sent to your registered email address.
                        </p>
                    <?php endif; ?>
                    <div class="mt-4">
                        <a href="dashboard.php" class="btn btn-primary">Back to Dashboard</a>
                        <a href="fee_statement.php" class="btn btn-secondary">View Fee Statement</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>