<?php
require_once '../config/config.php';
require_once '../controllers/AuthController.php';
require_once '../includes/functions.php';

session_start();

// Get student details
$stmt = $conn->prepare("SELECT s.id, s.student_number, s.first_name, s.last_name, p.program_name, s.year_level, u.email 
    FROM students s 
    LEFT JOIN programs p ON s.program_id = p.id 
    LEFT JOIN users u ON s.user_id = u.id 
    WHERE s.user_id = ?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$student = $stmt->get_result()->fetch_assoc();

// Get unpaid fees
$query = "SELECT sf.id, ft.amount as original_amount, sf.due_date, sf.status, ft.name as fee_type, ay.year_name, 
          (SELECT COALESCE(SUM(amount), 0) FROM payments WHERE student_fee_id = sf.id AND status = 'confirmed') as paid_amount 
          FROM student_fees sf 
          JOIN fee_types ft ON sf.fee_type_id = ft.id 
          JOIN academic_years ay ON sf.academic_year_id = ay.id 
          WHERE sf.student_id = ? AND (sf.status IS NULL OR sf.status = 'pending' OR sf.status = 'partial') 
          ORDER BY sf.due_date ASC, ft.name ASC";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $student['id']);
$stmt->execute();
$unpaid_fees = $stmt->get_result();

echo "<pre>";
echo "Student ID: " . $student['id'] . "\n";
echo "Number of fees found: " . $unpaid_fees->num_rows . "\n\n";

while ($row = $unpaid_fees->fetch_assoc()) {
    print_r($row);
}
echo "</pre>";
?>